"""Hungarian language user interface strings
   (c) MIK, 2002-05-35 0.2.0
   (c) FIT Fraunhofer, 1998-2003, (c) OrbiTeam 2001-2012
"""
__version__             = '5.1'

# E.Hinrichs, G.Woetzel, FIT Fraunhofer; K.Daniels, V.Paulsen, OrbiTeam
#---------------------------------------------------------------------------
# All code contained herein is covered by the Copyright as distributed
# in the BSCW_COPYRIGHT file in the main directory of the distribution
# of the BSCW server.
#---------------------------------------------------------------------------
############################################################################
# Message configuration:
#
# Default user interface messages for BSCW - details can be modified directly,
# or can be extended/overridden per language by editing a file lg_msgconfig.py
# in the language specific messages sub-directory.
#
#             Please keep the lg_msgconfig files in sync.
#
############################################################################
# Descriptions of BSCW Object types
Home                    = 'Munkaterület'
activeHome              = Home
labelHome               = 'Munka'
Public                  = 'Nyilvános terület'
activePublic            = Public
labelPublic             = 'Nyilv'
LockBag                 = 'Zárolt dokumentumok'
Bag                     = 'Vágóasztal'
activeBag               = Bag
unaviableBag            = Bag
fullBag                 = Bag
activeFullBag           = Bag
unaviableFullBag        = Bag
labelBag                = 'Vágó'
Waste                   = 'Kuka'
activeWaste             = Waste
unaviableWaste          = Waste
fullWaste               = Waste
activeFullWaste         = Waste
unaviableFullWaste      = Waste
labelWaste              = 'Kuka'
AddrBook                = 'Címjegyzék'
activeAddrBook          = AddrBook
unaviableAddrBook       = AddrBook
labelAddrBook           = 'Cím'
Calendar                = 'Naptár'
unaviableCalendar       = Calendar
fullCalendar            = Calendar
UserCalendar            = 'Saját naptár'
WSCalendar              = 'Csoport naptár'
labelCalendar           = 'Naptár'
Group                   = 'Tagok'
Group_anon              = Group
Member                  = 'Tag'
Member_is_anon          = Member
Member_is_bounced       = 'Érvénytelen levélcím'
Workspace               = 'Munkaterület'
Folder                  = 'Mappa'
ReplyToArticle          = 'Válasz'
Article                 = 'Megjegyzés'
Article_pro             = 'Egyetértés'
Article_con             = 'Kontra'
Article_angry           = 'Dühös'
Article_idea            = 'Ötlet'
Article_import          = 'Fontos!'
URL                     = 'URL'
URL_OK                  = URL
URL_BAD                 = URL
Document                = 'Dokumentum'
Lock                    = 'Dokumentum zárolása'
Note                    = 'Megjegyzés'
Noteboard               = 'Megbeszélés'
Search                  = 'Keresés'
SearchFolder            = 'Keresés'
UserSearchBag           = 'Felhasználói átmeneti tároló (keresés)'
AdminSearchBag          = 'Adminsztrátor átmeneti tárolója (keresés)'
BSCW_Query              = 'BSCW-lekérdezés'
BscwSearch              = 'BSCW-lkeresés'
UserSearch              = 'Felhasználói keresés'
simpleAltaVista         = 'AltaVista (egyszerű)'
advancedAltaVista       = 'AltaVista (összetett)'
Infoseek                = 'Infoseek'
Lycos                   = 'Lycos'
Excite                  = 'Excite'
Meeting                 = 'Összejövetel'
Meeting_conf            = 'Összejövetel elfogadva'
Meeting_decl            = 'Összejövetel visszautasítva'
Meeting_new             = 'Összejövetel *nincs* elfogadva'
# Role stuff
info_roles              = 'Szerepek'
info_mbroles            = 'Tag szerepei'
info_actions            = 'Megengedett műveletek'
info_members            = 'Szerep tulajdonosok'
info_admins             = 'BSCW adminisztrátorok'
info_others             = 'Tetszőleges regisztrált felhasználó'
role_is_defined         = 'erre az objektumra definiált'
role_is_invited         = 'meghíváskor definiált'
role_is_inherited       = 'Előző (magasabb) mappában definiálva'
role_is_redefined       = 'erre az objektumra újra-definiálva'

#R0creator        =
R0owner                 = 'Tulajdonos'
R0other                 = 'Regisztrált felhasználó'

#R1anonymous      =
R1restricted            = 'Korlátozott tag'

#R2attendee       =
R2manager               = 'Menedzser'
R2member                = Member
#R2responsible    =
R2user                  = 'Felhasználó'

view_other              = 'Tiltva'
view_get                = 'Olvasás'
view_get_ext            = 'Olvasás (kiterjesztett)'
view_change             = 'Szerkesztés'
view_change_ext         = 'Szerkesztés (kiterjesztett)'
view_owner              = 'Tulajdonos'
view_share              = 'Megosztás'
view_share              = 'Megosztás (kiterjesztett)'
view_user               = 'Felhasználó'
view_waste              = 'Kuka'
#view_attend    =
#view_edit      =
#view_creator   =

# Descriptions of BSCW event types
CreateEvent             = 'új'
NewEvent                = 'új'
EditEvent               = 'szerkesztett'
VersionEvent            = 'új verzió'
ChangeEvent             = 'változtatott'
ChangeDescEvent         = 'megváltoztatott leírás'
EditQueryEvent          = 'szerkesztett lekérdezés'
ApplyQueryEvent         = 'lekérdezés elküldve'
MoreHitsEvent           = 'további eredmények'
ChNoteEvent             = 'új megjegyzés'
ReplaceEvent            = 'lecserélve'
ChDetailsEvent          = 'új tulajdonságok'
ChAccessEvent           = 'új hozzáférési jogok'
CopyEvent               = 'másolva'
RenameEvent             = 'átnevezve'
PublishEvent            = 'közzé téve'
MoveEvent               = 'elköltöztetve'
CutEvent                = 'kivágva'
DropEvent               = 'beillesztve'
DeleteEvent             = 'eltávolítva'
UndeleteEvent           = 'eltávolítás visszavonva'
DestroyEvent            = 'törölve'
AddMemEvent             = 'tag meghívva'
RateEvent               = 'értékelve'
RemMemEvent             = 'tag eltávolítva'
RegMemEvent             = 'tag regisztrálva'
ReadEvent               = 'olvasva'
TouchEvent              = 'új eredmények'
VerifyOKEvent           = 'sikeresen ellenőrizve'
VerifyBadEvent          = 'sikertelen ellenőrzés'
# Mail events
reg_anon_ok             = 'regisztrálás'
reg_anon_fail           = 'jelszó'
reg_self                = 'másodlgos név'
reg_other               = 'meghívás'
reg_done                = 'regisztrált'
reg_bounced             = 'érvénytelennek nyilvánítva'
reg_pending             = 'függő'
# version control
ForgetEvent             = 'verzió törölve'
ChvnoEvent              = 'verzió (szám) változott'
ChvinfoEvent            = 'verzió-információ változott'
BranchEvent             = 'új verzió-ág (branch)'
ReviseEvent             = 'új verzió'
CheckinEvent            = 'fölszbadítva'
CheckoutEvent           = 'zárolt'
# Meeting support
CallEvent               = 'meghívva'
JoinEvent               = 'csatlakozott'
ConfirmEvent            = 'nyugtázva'
DeclineEvent            = 'elvetve'
ReminderEvent           = 'emlékeztető elküldve'
# Interface Scales
small                   = 'Kicsi'
medium                  = 'Közepes'
large                   = 'Nagy'
# Interface
m_location              = 'Az Ön helye'
a_drop                  = 'Beillesztés'
a_doc                   = 'Dokumentum hozzáadása'
a_info                  = 'Tájékoztatás'
a_fol                   = 'Mappa hozzáadása'
a_srch                  = 'Keresés'
a_memb                  = 'Tag hozzáadása'
a_notes                 = 'Vitafórum hozzáadása'
submit                  = 'Benyújtás (Submit)'
# misc
close_window            = 'ablak bezárása'
# Descriptions of actions
add                     = 'Hozzáadása'
addAddr                 = 'Címjekzékhez'
adddocument = adddocument_Simple = adddocument_Basic = adddocument_Plain = 'Dokumentum hozzáadása'
addfolder               = 'Mappa hozzáadása'
addmember               = 'Tag meghívása'
addaddress              = 'Tag hozzáadása a Címjegyzékhez'
addnote                 = 'Jegyzet hozzáadása'
addnotes                = 'Vitafórum hozzáadása'
addrole                 = 'Új szerep'
addSearch               = 'Új kersés'
addurl                  = 'Új URL'
addws                   = 'Új munkaterület'
addMailAddr             = 'EMail cím hozzáadása'
alias                   = 'Másodlagos Mail-cím regisztrálása'
admin                   = 'Adminisztráció'
allocateMailAddr        = 'hozzárendel'
applyQuery              = 'Keresés ismét'
archive                 = 'Archiválás'
bouncedMailAddr         = 'Érvénytelennek nyivánítva'
catchup                 = 'Megnézés'
chacts                  = 'Művelet tulajdonságainak megváltoztatása'
change_pwd              = 'Jelszóváltás'
chpwd                   = change_pwd
chbanner                = 'Felcím szerkesztése'
checkin                 = 'Fölszbadítás'
checkout                = 'Zárolás'
chown                   = 'Tulajdonos'
chrole                  = 'Szerep hozzárendelés'
chtype                  = 'Típus változtatás'
contents                = 'Tartalom'
convert                 = 'Átalakítás'
copy                    = 'Másolás'
cut                     = 'Kivágás'
delAddr                 = 'Címjegyzékből'
deleteObj               = 'Eltávolítás'
deleteMem               = 'Kiűrítés'
destroy                 = 'Törlés'
destroyUser             = destroy
drop                    = 'Beillesztés'
edit                    = 'Szerkesztés'
editdescription         = 'Leírás szerkesztés'
changedetails           = 'Részletek szerkesztése'
edit_prefs              = 'Beállítások szerkesztése'
editnote                = 'Jegyzet szerkesztése'
editQuery               = 'Keresés (lekérdezés szerkesztése)'
editrole                = 'Szerep megváltoztatása'
editurl                 = 'URL szerkesztése'
# Awareness Configuration:
editawconfig            = 'Eseményszűrő beállítás'
viewawconfig            = 'Eseményszűrő megtekintés'
editawdefaults          = 'Alapértelmezett eseményszűrő beállítás'
event_serv_enabled      = 'elindítva'
event_services          = 'Esemény-szolgáltatás:'
evt_read                = 'Olvasás típúsú esemény'
evt_create              = 'Létrehozás típúsú esemény'
evt_move                = 'Áthelyezés (elmozdítás) típúsú esemény'
evt_change              = 'Változtatás típúsú esemény'
aw_internal             = 'Esemény-ikonok'
daily_report            = 'Napi riport'
aw_email                = 'Azonnali Email'
aw_nessie               = 'Nessie'
# /AWConfig.
extract                 = 'Kinyerés (kicsomagolás)'
export                  = 'Exportálás'
export_rejected         = 'Exportálás'
get                     = 'Olvasás'
history                 = 'Előzmények megtekintése'
invite                  = 'Ismételt meghívás'
lastSearch              = 'Utolsó keresés'
login                   = 'Bejelentkezés'
mail_to                 = 'Email'
modify                  = 'Módosítás'
modifyConvertors        = 'Konverterek módosítása'
modifyEncoders          = 'Kódolók módosítása'
modifyMimeTypes         = 'Mime-típusok(Mime-Types) módosítása'
modifyRegistry          = 'Regisztráció módosítása'
modifyServer            = 'Kiszolgáló módosítása'
moreHits                = 'További találatok'
move                    = 'Elmozdítás'
nextnote                = 'Következő megjegyzés'
pendingMailAddr         = 'Függő'
prevnote                = 'Előző megjegyzés'
publish                 = 'Közzététel'
pubaccess               = 'Nyilvánossá tétel'
rate                    = 'Értékelés'
register                = 'Felhasználó regisztrálása'
refresh                 = 'Frissítés'
rename                  = 'Átnevezés'
renameUser              = rename
replace                 = 'Helyettesítés'
replynote               = 'Válasz'
resend                  = 'Ismételt küldés'
rmail                   = 'Felhasználó regisztrálása'
saveurl                 = copy
save_search             = 'Mentés másként'
search                  = 'Keresés'
send                    = 'Küldés'
send_email              = 'Email küldés'
send_fax                = 'FAX küldés'
send_email_plain        = send_email
selectPart              = 'Résztvevők kiválasztása'
preview                 = 'Előzetes megtekintés'
sort_byType             = 'Típus szerint'
sort_byRank             = 'Rangsorolás szerint'
sort_byRating           = 'Értékelés szerint'
sort_byName             = 'Név szerint'
sort_byLocation         = 'Hely szerint'
sort_bySubject          = 'Tárgy szerint'
sort_byDate             = 'Dátum szerint'
sort_byAuthor           = 'Szerzők szerint'
sort_byThread           = 'Szál szerint'
subgroup                = 'Új csoport'
undelete                = 'Törlés visszavonása'
uploadurl               = 'Feltöltés'
UserAdmin               = 'Felhasználó adminsztráció'
verifyurl               = 'Ellenőrzés'
viewlock                = 'Zárolás okának megtekintése'
steallock               = 'Zárolás feloldása'
wwwSearch               = 'Web-keresés'
db                      = 'Debug'
# Meeting support
addmeeting              = 'Új összejövetel'
chmeettime              = 'Találkozó idejének módosítása'
chmeetloc               = 'Találkozó helyének módosítása'
chmeetpart              = 'Résztvevők megváltoztatása'
chmeetnotes             = 'Megjegyzés megváltoztatása'
confirmatt              = 'Elfogadás'
declineatt              = 'Elvetés'
delentry                = 'Bejegyzés eltávolítása'
getvcal                 = 'vCalendar formátum'
getvcard                = 'vCard'
reminder                = 'Emlékeztető küldése'
joinmeet                = 'Résztvétel'
viewall                 = 'Teljes nézet'
viewfuture              = 'jövő'
thismonth               = 'ez a hónap'
thisyear                = 'ez az év'
# workspace report
##wsreport                = 'Napi riport beállítása'
dailymailnotification_subject = 'Napi riport'
mailnotification_activitiestitle = 'Aktivitás a'

invite_mail_subject     = 'Meghívás egy közös munkaterületre'
# direct email notification
directmailnotification_subject = 'Azonnali email értesítés'
mailnotification_activitytitle = 'Aktivitás a'
# version control
firstversion            = 'Verziókontroll alá helyezés'
chvinfo                 = 'Verzió-Iinformáció'
forget                  = 'Verziók törlése'
branch                  = 'Új verzió-ág'
revise                  = 'Új verzió'
# Labels of row in the head line of a container listing
# (should be short names)
label_name              = 'Név'
label_shared            = 'Megosztva'
label_note              = 'Megjegyzés'
label_rating            = 'Értékelés'
label_owner             = 'Tulajdonos'
label_date              = 'Dátum'
label_events            = 'Események'
label_action            = 'Művelet'

label_category          = 'Kategória'
label_location          = 'Hely'
label_tools             = 'Eszközök'
label_parts             = 'Meghívott résztvevők'

# Name of actions as the menu item
# (should be start with a upper-case letter)
menu_addAddr            = 'Címjegyzék'
menu_adddocument        = 'Dokumentum'
menu_addfolder          = 'Mappa'
menu_addmeeting         = 'Összejövetel'
menu_addmember          = 'Tag meghívása'
menu_addnote            = 'Megjegyzés hozzáfűzése'
menu_addnotes           = 'Vitafórum'
menu_addrole            = addrole
menu_addSearch          = 'Keresés'
menu_addurl             = 'URL'
menu_admin              = 'Adminisztráció'
menu_allocateMailAddr   = 'Hozzárendelés'
menu_applyQuery         = 'Ismét keresés'
menu_archive            = archive
menu_bouncedMailAddr    = bouncedMailAddr
menu_branch             = branch
menu_catchup            = catchup
menu_change_pwd         = change_pwd
menu_chbanner           = chbanner
menu_checkout           = checkout
menu_chmeetloc          = 'Hely'
menu_chmeetnotes        = 'Leírás'
menu_chmeetpart         = 'Résztvevők'
menu_chmeettime         = 'Összejövetel időpontja'
menu_chown              = chown
menu_chrole             = chrole
menu_chtype             = chtype
menu_chvinfo            = 'Verzió-Iinformáció'
menu_confirmatt         = confirmatt
menu_contents           = contents
menu_convert            = convert
menu_copy               = copy
menu_cut                = cut
menu_declineatt         = declineatt
menu_delentry           = delentry
menu_deleteMem          = deleteMem
menu_deleteObj          = deleteObj
menu_destroy            = destroy
menu_destroyUser        = destroyUser
menu_drop               = drop
menu_edit               = edit
menu_editQuery          = editQuery
menu_edit_prefs         = 'Beállítások'
menu_editrole           = editrole
menu_editawconfig       = 'Események'
menu_editawdefaults     = 'Alapértelmezett események'
menu_editdescription    = 'Leírás'
menu_editnote           = 'Szerkesztés'
menu_editurl            = 'Szerkesztés'
menu_export             = export
menu_extract            = extract
menu_firstversion       = 'Verziókontroll'
menu_forget             = 'Verziók törlése'
menu_get                = 'Megnyitás'
menu_getvcal            = 'V-Calendar formátum'
menu_getvcard           = 'V-Card formátum'
menu_history            = 'Történet'
menu_info               = 'Tájékoztatás'
menu_invite             = invite
menu_joinmeet           = joinmeet
menu_login              = 'Kijelentkezés'
menu_mail_to            = mail_to
menu_moreHits           = moreHits
menu_orginfo            = 'Céginformáció'
menu_pendingMailAddr    = pendingMailAddr
menu_pubaccess          = pubaccess
menu_publish            = publish
menu_rate               = rate
menu_reminder           = 'Emlékeztető'
menu_rename             = rename
menu_renameUser         = renameUser
menu_replace            = replace
menu_replynote          = replynote
menu_revise             = revise
menu_save_search        = save_search
menu_select_all         = 'Mindet kijelöl'
menu_select_none        = 'Semmit nem jelöl ki'
menu_send               = send
menu_send_email         = send_email
menu_send_fax           = send_fax
menu_sort_byAuthor      = 'Szerzők szerint'
menu_sort_byDate        = 'Dátum szerint'
menu_sort_byLocation    = 'Hely szerint'
menu_sort_byName        = 'Név szerint'
menu_sort_byRank        = 'Rangsorolás szerint'
menu_sort_byRating      = 'Értékelés szerint'
menu_sort_bySubject     = 'Tárgy szerint'
menu_sort_byThread      = 'Szál szerint'
menu_sort_byType        = 'Típus szerint'
menu_sort_byStart       = 'Kezdőpont szerint'
menu_sort_byCategory    = 'Kategória szerint'
menu_toggle_actions     = 'Műveletek'
menu_toggle_descr       = 'Leírások'
menu_toggle_events      = 'Események'
menu_toggle_moddate     = 'Dátum'
menu_toggle_msg         = 'Üzenetek'
menu_toggle_notes       = 'Megjegyzések'
menu_toggle_owner       = 'Tulajdonos'
menu_toggle_rating      = 'Értékelés'
menu_toggle_shared      = 'Megosztva'
menu_uploadurl          = uploadurl
menu_verifyurl          = verifyurl
# Further Menu item names
menu_get_home           = Home
menu_get_bag            = Bag
menu_get_waste          = Waste
menu_get_calendar       = Calendar
menu_get_addbook        = AddrBook
menu_get_public         = Public
menu_help               = 'Súgó'
menu_help_faq           = 'GyIK (Gyakran Ismételt Kérdések)'
menu_help_index         = 'Index'
menu_help_bscw          = 'BSCW Home'
menu_help_orbiteam      = 'OrbiTeam'
menu_help_about         = 'Névjegy'
menu_info_user          = 'Informácó a felhasználóról'
menu_search_bscw        = 'A BSCW-kiszolgálón'
menu_search_user        = 'Felhasználó'
menu_search_www         = 'Világhálózaton (Internet)'
menu_toggle_all         = 'Mind'
menu_toggle_small       = 'Kicsi'
menu_toggle_medium      = 'Közepes'
menu_toggle_large       = 'Nagy'
menu_Color              = 'Színbeállítás'
menu_toggle_crt         = 'Hagyományos monitor (CRT)'
menu_toggle_lcd         = 'Hordozható számítógép (LCD)'
menu_toggle_straight    = 'Egyszerű'
menu_toggle_shortcuts   = 'Parancsikonok'
# menus and submenus
menu_M_Main             = 'Fájl'
menu_Edit               = 'Szerkesztés'
menu_View               = 'Nézet'
menu_Options            = 'Eszközök'
menu_M_GoTo = menu_CGoTo = 'Ugrás'
menu_Help               = 'Súgó'
menu_M_New              = 'Új'
menu_M_Access           = 'Megosztás'
menu_M_Search           = 'Keresés'
menu_Columns            = 'Oszlopok'
menu_Scale              = 'Méretezés'
menu_Sort               = 'Rendezés'
menu_M_Actions          = 'Műveletek'

c_actions               = 'Műveletek'
action_s                = c_actions
# rating
no_rating               = 'nincs értékelés'
rate_1                  = 'rossz'
rate_2                  = 'elfogadható'
rate_3                  = 'megfelelő'
rate_4                  = 'jó'
rate_5                  = 'kiváló'
rated_by                = '%s értékelés(ek)'
rated_that_by           = '%s értékelés(ek): %s'
users                   = 'felhasználó(k)'
times                   = 'szor'
usr_anno                = '<em>%s</em><br />%s<p />'
usr_rate                = '<em>%s:</em> %s<br />'
rate_entry_as           = 'minősítve, mint'
# Misc descriptions
select_all              = 'Mind kijelölve'
select_none             = 'Semmi sincs kijelölve'
select_all_status       = 'A mappa minden objektumának kijelölése'
select_none_status      = 'Semmi sincs kijelölve ebben a mappában'
show_sub_all            = 'Mappák kinyitása'
hide_sub_all            = 'Mappák bezárása'
show_sub                = 'Kinyitás'
hide_sub                = 'Bezárás'
hide_actions            = 'Műveletek elrejtése'
show_actions            = 'Műveletek megmutatása'
hide_descriptions       = 'Leírások elrejtése'
show_descriptions       = 'Leírások megmutatása'
info                    = 'További információ'
infoPublic              = 'További információ'
copyright               = 'BSCW Home Page'
about                   = 'Névjegy'
help                    = 'Súgó'
banner = formbanner = infobanner = searchbanner = "byMIK & BSCW © GMD.FIT"
caution                 = 'Vigyázat!'
new_meeting             = 'Új összejövetel'
refresh_notify          = 'Megerősítés'
# various labels of form fields
formfield_label_name    = label_name
label_description       = 'Leírás'
formfield_label_description = label_description
formfield_label_description_opt = 'Leírás (opcionális):'
# selection forms
option_label_any        = 'bármely'
form_label_or           = 'vagy'
button_label_restore_default = 'Alapértelmezett beállítás visszaállítása'
button_label_edit_default = 'Alapértelmezett beállítás módosítása'
# msg in op_send_mail
attachments             = 'Csatolás (összesen %(count)s kiválasztott objektum, a teljes méret: %(size)s ):'
send_hint_invalid       = 'Az <br><UL>%s</UL> e-mail címet nem lehetett feloldani.'
send_hint_bigmsg        = 'Ön egy hosszú üzenetet szándékozik küldeni. Ez néhány levelezőkiszolgálón problémát okozhat. Üzenetének becsült hossza: %s.<br>'
bytes                   = '%s bytes'
kbytes                  = '%.1f KB'
mbytes                  = '%.2f MB'
sel_email               = 'Választás a címjegyzékből'
send_hint               = 'Javaslat'
send_rejected           = 'Probléma'
# msg in op_send_fax
fax_attachments         = 'Csatolás (%(count)s kiválasztott objektum):'
sel_faxno               = 'Választás a címjegyzékből'
preview_fax             = 'Előzetes megtekintés'
# msg in op_subgroup
subgroupab              = """Amennyiben Ön nem tagja az új csoportnak, akkor mint tuljdonos érheti el az új, megosztott mappát, azonban az Ön alapértelmezett munkaterületi mappájában nem jelenik meg."""
subgroupmb              = """<em>%(members)s</em> nem lesz(nek) a továbbiakban közvetlen tagjai a <em>%(folder)s</em> mappának. A mappához az új alcsoport tagjaiként férhetnek hozzá."""
# Misc message strings
owners_of               = 'Tulajdonosa'
members_of              = 'Tagja'
is_member_of            = 'a következő csoport(ok) tagja'
max_priority            = 'a legnagyobb prioritású érték'
addrbook_of             = 'címjegyzék tulajdonosa: %(user)s'
unresolved_msg          = """<strong>A rendszer nem tudta feloldani a levélcímet.
                     Vagy a cím, vagy a név hibás.
                     A címtárba nem lett fölvéve.</strong>"""
everywhere              = 'teljes rendszer'
addrbook                = 'címjegyzék'
no_objects              = '<p><strong>Jelenleg nincs objektum.</strong></p>'
back                    = 'Vissza'
back_to_home            = 'Kezdőpont'
none                    = 'semmi'
note                    = 'Nincs szöveg'
yes                     = 'igen'
no                      = 'nem'
empty                   = ' '
versions                = 'verziók'
replaced                = 'lecserélve, a legújabb:'
re                      = 'VA:'
mime_from_browser       = '(böngésző által)'
notes_to                = 'Megjegyzés:'
allocated_to            = 'hozzárendelve:'
# info strings
more_about              = 'További információ'
i_from                  = 'of'
i_type                  = 'of %(type)s %(name)s'
i_details               = 'Részletek'
i_admin                 = 'Adminisztrátor adatok'
i_access                = 'Hozzáférési jogok'
i_versions              = 'Verzió történet'
i_branches              = 'Kapcsolódó verzióágak'
Member_is_pending       = 'továbbra is függő'
is_bounced              = 'érvénytelen'
i_back                  = 'Vissza'
i_forward               = 'Előre'
i_close                 = 'Bezárás'
inf_bag                 = 'vágóasztal'
inf_doc                 = 'dokumentum'
inf_folder              = 'mappa'
inf_home                = 'Munkaterület'
inf_item                = 'URL'
inf_mail                = 'mailcím'
inf_meet                = 'összejövetel'
inf_note                = 'Megjegyzés'
inf_notes               = 'Megbeszélés'
inf_url                 = 'URL'
inf_user                = 'Felhasználó'
inf_waste               = 'kuka'
# quota
quota_byte              = 'bájt'
quota_file              = 'fájl(ok)'
quota_unit              = 'Egység(ek)'
# fetch/verify url
url_local               = 'helyi URL'
url_badtype             = 'ismeretlen URL típus'
url_redirect            = 'túl sok URL-átirányítás'
# versions
exp                     = 'kisérleti'
stb                     = 'stabil'
rel                     = 'forgalomba hozott'
# user interface management stuff
sort_by                 = '<strong>Rendezés: </strong>%s'
ui_selfdef              = ' és ön-definiált'
ui_beginner             = 'Kezdő'
ui_advanced             = 'Haladó'
ui_expert               = 'Szakértő'
# Calendar / Appointment unsorted
# menunames
menu_Calendar           = 'Naptár'
menu_CView              = menu_View
menu_COptions           = menu_Options
menu_Entries            = 'Bejegyzés'
menu_AEdit              = 'Szerkesztés'
# names for actions & respective menuitems
multiact_fail           = 'Befejezetlen műveletsor'
addcal                  = 'Új csoportnaptár'
menu_addcal             = 'Csoportnaptár'
allcalpref              = 'Alapértelmezett naptár beállítások'
calpref                 = 'Naptár beállítások'
menu_allcalpref         = 'Naptár'
menu_calpref            = 'ez a naptár'
menu_sw_time            = 'Vége'
menu_sw_check           = 'Kijelölő doboz'
menu_sw_info            = 'Tájékoztatás'
menu_sw_icon            = 'Kép'
menu_sw_name            = 'Név'
menu_sw_shared          = 'Megosztva'
menu_sw_notes           = 'Megjegyzés'
menu_sw_rating          = 'Értékelés'
menu_sw_owner           = 'Tulajdonos'
menu_sw_date            = 'Dátum'
menu_sw_events          = 'Események'
menu_sw_actions         = 'Műveletek'
menu_sw_descr           = 'Leírás'
menu_sw_default         = 'Alapértelmezett'
menu_sw_all             = 'Mind'
menu_sw_skipwkend       = 'hétvége átugrása'
menu_sw_hiwkend         = 'hétvége kiemelése'
menu_sw_hiholy          = 'szünnapok kiemelése'
nav                     = 'Új dátum'
year                    = 'Év'
menu_year               = year
month                   = 'Hónap'
menu_month              = month
week                    = 'Hét'
menu_week               = week
day                     = 'Nap'
menu_day                = day
menu_goask              = 'Dátum'
menu_today              = 'Ma'
goback                  = 'Előző'
goforw                  = 'Következő'
add2cal                 = 'Új megbeszélés'
menu_add2cal            = 'Megbeszélés'
getical                 = 'iCalendar'
menu_getical            = getical
getsingleobj            = 'Megnyitás'
menu_getsingleobj       = getsingleobj
link2cal                = 'a naptárba'
menu_link2cal           = link2cal
menu_aptconfirm         = 'Elfogadás'
menu_aptdecline         = 'Lemondás'
getattach               = 'Csatolás'
menu_getattach          = 'Csatolások'
editapt                 = 'Megbeszélés tulajdonságainak módosítása'
menu_editapt            = 'Mind'
chsummary               = 'Átnevezés'
menu_chsummary          = 'Név'
chdtime                 = 'Dátum/Idő megváltoztatása'
menu_chdtime            = 'Dátum/Idő'
chdescr                 = editdescription
menu_chdescr            = menu_editdescription
chloc                   = 'Hely megváltoztatása'
menu_chloc              = 'Hely'
chpart                  = 'Résztvevők hozzáadása/eltávolítása'
menu_chpart             = 'Résztvevők'
chstatus                = 'Státusz beállítása'
menu_chstatus           = 'Státusz'
chreminder              = 'Emlékeztető küldése'
menu_chreminder         = 'Email-emlékeztető'
sendreminder            = 'Emlékeztető'
menu_sendreminder       = 'Emlékeztető'
wsmb                    = 'Munkaterület'
addrb                   = 'címjegyzék'
resolve_groups          = 'kiválasztott csoport(ok) feloldása'

# Descriptions of actions in the multi action shortcut line
# should start with a lower-case letter, not too long
# where: multi action shortcut row just above the entries in a folder listing
multi_addAddr           = addAddr
multi_archive_select    = archive
multi_bouncedMailAddr   = bouncedMailAddr
multi_catchup           = catchup
multi_copy              = copy
multi_cut               = cut
multi_drop              = drop
multi_cutattachment     = multi_cut
multi_deleteMem         = deleteMem
multi_deleteObj         = deleteObj
multi_destroy           = destroy
multi_destroyUser       = multi_destroy
multi_firstversion      = firstversion
multi_invite            = invite
multi_mail_to           = mail_to
multi_pendingMailAddr   = pendingMailAddr
multi_rate              = rate
multi_replynote         = replynote
multi_saveurl           = multi_copy
multi_send_email_select = send_email
multi_subgroup          = subgroup
multi_undelete          = undelete
multi_uploadurl         = uploadurl
multi_verifyurl         = verifyurl
multi_delentry          = deleteObj
multi_link2cal          = link2cal
multi_getical           = getical


# other stuff
dismiss                 = 'Rendben'
calendar_of             = 'Naptár: %(name)s'
a_appt = new_appt       = add2cal
op_add                  = '%s %s-hoz'
op_change               = '%s ( %s ) megváltoztatása'
all_day                 = 'Mindennap'
wdaynames               = ('Hétfő','Kedd','Szerda','Csütörtök','Péntek','Szombat','Vasárnap')
attachments_to          = 'Csatolások a következő számára: '
newentry                = 'Új megbeszélés'
location                = label_location
category                = label_category
msg_access_key          = 'az Ön által végrehajtott művelet nyomán egy email-t fog kapni a emgbeszélés státuszával kapcsolatban. \nEz az email tartalmazza az új URL-eket, melyeket a következő hozzáférési-kulccsal használhat: %s'
#categories for appointment etc
appointment             = 'Megbeszélés'
business                = 'Üzleti'
meeting                 = 'Összejövetel'
phonecall               = 'Telefon'
education               = 'Oktatás'
holiday                 = 'Ünnepnap'
spec_occasion           = 'Különleges alkalom'
private                 = 'Személyes'
travel                  = 'Utazás'
miscellaneous           = 'Egyéb'
# rfc2445
attendee_state0         = 'műveletek szükséges'
attendee_state1         = 'elfogadva'
attendee_state2         = 'elutasítva'
attendee_state3         = 'határozatlan'
attendee_state4         = 'delegált'
attendee_role0          = ''
attendee_role1          = 'szükséges'
attendee_role2          = 'opcionális'
attendee_role3          = 'nem-résztvevő'
event_statusX           = 'automatikusan'
event_status0           = 'határozatlan'
event_status1           = 'elfogadva'
event_status2           = 'elutasítva'
#todo_status0   = 'needs-action'
#todo_status1   = 'completed'
#todo_status2   = 'cancelled'
#todo_status3   = 'in-process'
#vevent_class0  = 'Private'
#vevent_class1  = 'Public'
#vevent_class2  = 'Confidential'
priority0 = priorityno  = 'nincs'
priority1 = priorityhi  = 'magas'
priority5 = prioritynorm = 'normális'
priority9 = prioritylo  = 'alacsony'
#freebusy0      = 'Free'
#freebusy1      = 'Busy'
# Meeting support
view                    = 'Nézet'
addme                   = 'Módosítás / Hozzáadás'
a_reminder              = 'Ez egy emlékeztető!'
participants            = 'Meghívott résztvevők'
upload                  = 'Dokumentum hozzáadása az asztalról:'
noone                   = '<i>senki</i>'
confirmed               = 'Elfogadva'
declined                = 'Elutasítva'
needsaction             = '(művelet szükséges)'
no_meetings             = '<p><strong>Ön jelenleg egy összejövetelre sincs meghívva.</strong></p>'
no_workspaces           = '<p><strong>Ön jelenleg egy munkaterületnek sem tagja. Kattintson a "Mappa hozzáadása" gombra egy új mappa létrehozásához.</strong></p>'
calendar_msg            = '<em>Összejövetelek, ahova az összes munkaterületről meg van hívva</em>'
cal_prefix              = 'Az összejövetel célja'
viewingall              = '<strong>minden</strong> bejegyzés...'
viewingfuture           = 'csak <strong>későbbi</strong> bejegyzések...'
viewingmonth            = 'csak <strong>az e havi</strong>\'s bejegyzések...'
viewingyear             = 'csak <strong>az ez évi</strong>\'s bejegyzések...'
changed_time            = '- Az összejövetel ideje megváltozott -'
changed_loc             = '- Az összejövetel helye megváltozott -'
changed_part            = '- Ön meg lett hívva -'
changed_notes           = '- Az összejövetel notes have changed -'
inf_geoloc              = 'Hely'
inf_telnr               = 'Telefonszám'
inf_iaddr               = 'Internet-cím'
inf_addrnumber          = 'Cím/Szám'
meetlocatedin           = 'az összejövetel helye:'
meetdocs                = 'Az összejövetellel kapcsolatos dokumentumok és objektumok:'
monthnames              = ('Január','Február','Március','Április','Május','Június','Július','Augusztus','Szeptember','Október','November','December')
short_monthnames        = ('Január','Február','Március','Április','Május','Június','Július','Augusztus','Szeptember','Október','November','December')
daynames                = ('H','K','Sze','Cs','P','Szo','V')
timezones               = {-12:'GMT-12 Eniwetok',
-11:'GMT-11 Samoa',
-10:'GMT-10 Hawaii',
-9:'GMT-9  Alaska',
-8:'GMT-8  Pacific Time: Vancouver, San Francisco',
-7:'GMT-7  Mountain Time: Denver, Albuquerque',
-6:'GMT-6  Central Time: New Orleans, Mexico City',
-5:'GMT-5  Eastern Time: Montreal, New York, Lima',
-4:'GMT-4  Atlantic Time: Halifax, La Paz, Santiago',
-3:'GMT-3  Rio de Janeiro, Buenos Aries',
-2:'GMT-2  Mid-Atlantic',
-1:'GMT-1  Azores, Cape Verdes',
0:'GMT    Western Europe: Dublin, Lisbon, London',
1:'GMT+1  Central Europe: Berlin, Paris, Vienna',
2:'GMT+2  Eastern Europe: Athens, Helsinki, Jerusalem',
3:'GMT+3  Moscow, Kuwait, Nairobi',
4:'GMT+4  Abu Dhabi, Muscat, Tiflis',
5:'GMT+5  Islambad, Karachi',
6:'GMT+6  Almaty, Dhaka, Colombo',
7:'GMT+7  Bangkok, Jakarta',
8:'GMT+8  Hong Kong, Beijing, Singapore',
9:'GMT+9  Tokyo, Osaka, Irtusk, Seoul',
10:'GMT+10 Sydney, Melbourne, Guam',
11:'GMT+11 Magadan, Soloman Is.',
12:'GMT+12 Wellington, Auckland, Fiji',
}
t_other                 = 'Egyéb szoftver'
t_phone                 = 'Telefon'
t_face_to_face          = 'Szemtől-szembe'
# event status line messages
events_since            = 'az Ön utolsó megerősítése óta (<strong>%s</strong>)'
fromMsg                 = '%(name)s-tól, %(date)s'
owned_byMsg             = '(%(name)s) %(date)s'
invited_byMsg           = 'A meghívó: %(name)s, %(date)s'
CreateEventMsg          = 'előállította: %(name)s, %(date)s'
CopyEventMsg            = 'a másolatot (eredeti: %(copied)s) előállította: %(name)s, %(date)s'
ReplaceEventMsg         = 'helyettesítette: %(name)s, %(date)s'
VersionEventMsg         = 'verziókontroll alá vonta: %(name)s, %(date)s'
ChangeEventMsg          = 'tulajdonságokat módosította: %(name)s, %(date)s'
CheckinEventMsg         = 'zárolást föloldotta: %(name)s, %(date)s'
CheckoutEventMsg        = 'zárolta: %(name)s, %(date)s'
RenameEventMsg          = '%(source)s-t átnevezte: %(name)s, %(date)s'
PublishEventMsg         = 'közzétette: %(name)s, %(date)s'
ChangeDescEventMsg      = 'leírást módosította: %(name)s, %(date)s'
EditQueryEventMsg       = 'keresési kifejezést módosította: %(name)s, %(date)s'
ApplyQueryEventMsg      = 'a keresést végezte: %(name)s, %(date)s'
MoreHitsEventMsg        = 'további keresési eredményt hozzáfűzött: %(name)s, %(date)s'
ChNoteEventMsg          = 'zárolási megjegyzést módosította: %(name)s, %(date)s'
ChDetailsEventMsg       = 'tulajdonságokat módosította: %(name)s, %(date)s'
ChAccessEventMsg        = 'hozzáférési jogokat módosította: %(name)s, %(date)s'
EditEventMsg            = 'módosította: %(name)s, %(date)s'
CutEventMsg             = '%(source)s-t kivágta: %(name)s, %(date)s'
DropEventMsg            = '%(target)s-t beillesztett: %(name)s, %(date)s'
DeleteEventMsg          = '%(source)s-t törölte: %(name)s, %(date)s'
UndeleteEventMsg        = '%(target)s törlését visszvonta: %(name)s, %(date)s'
DestroyEventMsg         = 'törölve, %(date)s'
ReadEventMsg            = 'olvasta: %(name)s, %(date)s'
AddMemEventMsg          = 'meghívva, mint %(group)s tag, %(name)s által, %(date)s'
RemMemEventMsg          = 'meghívás törölve, mint %(group)s tag, %(name)s által, %(date)s'
RegMemEventMsg          = 'regisztrálva %(name)s%(group)s tagként, %(date)s'
VerifyOKEventMsg        = 'az ellenőrzést %(name)s sikeresen végrehajtotta, %(date)s'
VerifyBadEventMsg       = 'a sikertelen ellenőrzést %(name)s végezte, %(date)s'
RateEventMsg            = '%(name)s értékelte, %(date)s'
ExportEventMsg          = '%(name)s exportálta %(site)s-ra, %(date)s'
LinkEventMsg            = '%(target)s-t %(name)s fűzte hozzá, %(date)s'
ChangeDateEventMsg      = '%(name)s módosította a dátumot, %(date)s'
ChangeLocationEventMsg  = '%(name)s módosította a helyet, %(date)s'
# Mail events
reg_anon_okMsg          = '%(invitor)s regisztrációt igényelt, %(date)s'
reg_anon_failMsg        = '%(invitor)s jelszó-adatlapot igényelt, %(date)s'
reg_selfMsg             = '%(name)s másodlagos Mail-címet igényelt, %(date)s'
reg_otherMsg            = 'a meghívást %(name)s küldte, %(date)s'
reg_doneMsg             = '%(name)s részére van regisztrálva, %(date)s'
reg_bouncedMsg          = '%(name)s érvénytelennek nyilvánította, %(date)s'
reg_pendingMsg          = '%(name)s függő állapotba helyezte, %(date)s'
# Version control
ChvinfoEventMsg         = '%(name)s módosította verziós információt, %(date)s'
ForgetEventMsg          = '%(name)s verzió(ka)t törölt, %(date)s'
BranchEventMsg          = '%(name)s új verzió-ágat hozott létre, %(date)s'
ChvnoEventMsg           = '%(name)s verziót-számot módosított, %(date)s'
ReviseEventMsg          = '%(name)s új verziót hozott létre, %(date)s'
groupMsg                = ' %s-é'
targetMsg               = ' %s-hoz'
sourceMsg               = ' %s-tól'
copiedMsg               = ' %s-é'
no_events               = 'Nincs új esemény az utolsó megerősítés óta.'
# Meeting support
JoinEventMsg            = '%(name)s részt vett az összejövetelen, %(date)s'
CallEventMsg            = '%(name)s hívta fel a felhasználót, %(date)s'
ConfirmEventMsg         = '%(name)s megerősítette résztvételi szándékát, %(date)s'
DeclineEventMsg         = '%(name)s lemondta résztvételi szándékát, %(date)s'
ReminderEventMsg        = '%(name)s küldte az emlékeztetőt, %(date)s'
# BackupRestore Events, if the package was used
BackupEvent             = 'mentve'
BackupEventMsg          = '%(name)s végezte a mentést, %(date)s'
RestoreEvent            = 'helyreállítva'
RestoreEventMsg         = '%(name)s végezte a helyreállítást a %(server)s szerverről, %(date)s'
# Messages for search mechanism
sorted                  = 'rendezve'
noMatch                 = 'A keresési mintának megfelelő objektum nem található.'
docMatch                = '%d objektum felel meg a keresési mintának.'
docMatch1               = 'Egy objektum felel meg a keresési mintának.'
docStored               = ' %d lett eltárolva.'
allStored               = 'Mind el lett tárolva.'
searchFolder            = 'keresés <em>%s</em>-ban.'
defaultQuery            = 'Alapértelmezett kérdés'
lastQuery               = 'Utolsó kérdés'
deleteSelected          = 'A kiválasztottak törlése'
deleteTerm              = 'Keresési kifejezés törlése'
helpQuery               = 'Keresési súgó'
lastResults             = 'Utolsó eredmények'
search_busy             = '%s kersés folyamatban van; próbálja később!'
AND                     = 'és'
OR                      = 'vagy'
# login
login_failed            = 'A bejelentkezés sikertelen. Kérem, próbálja újra.'

# default values for various buttons
# (may need to be redfined in given context)
upItem                  = 'Fel'
downItem                = 'Le'
add_button              = add
delete_button           = deleteObj
remove_button           = destroy
up_button               = upItem
down_button             = downItem
# used: addmember
left_button             = deleteObj
# used: addmember
right_button            = add
edit_button             = edit

# Messages for converting and archiving
default_ext             = 'Archívum nevének kiegészítése a szokásos kiterjesztéssel'
check_ext               = 'Fájl nevének kiegészítése a szokásos kiterjesztéssel'
debug_info              = 'Debug információ szolgáltatása'
reject_info             = """A következő objekumok nem lettek archíválva:
    <br><UL>%s</UL>"""
archive_subject         = 'Archív: %(name)s'
# Time strings
never                   = 'soha'
today                   = 'ma'
yesterday               = 'tegnap'
# Access control/groups strings
# ac_controls = ('undefined', 'inherited', 'all', 'never', 'always')
ac_controls             = ('-','levezetett','igen','nem','igen*')
# change member/ownership
ac_downers_label        = "tulajdonosok eltávolítása:"
ac_powners_label        = "tulajdonosok hozzáadása:"
ac_pmembers_label       = "felhsználók/csoportok hozzáadása:"
# labels for buttons on access right forms
ac_enhanced             = 'Bővebb űrlap...'
ac_reset                = 'Alapértelmezett beállítás visszaállítása'
ac_columns              = 'Oszlopok módosítása...'
ac_addcol               = 'Oszlop hozzáadása...'
# various labels for extra buttons ...
chbanner_parent         = 'Örökölt felcím használata'
register_forgot_password = 'Jelszó elfeledése'
back_button             = back
more_users              = "Új felhasználók hozzáadása a címjegyzékhez..."
more_roles              = "Szerepek hozzáadása..."
edit_role               = "Szerep módosítása..."
reset_role              = "Szerep visszaállítása"
reset_chrole            = "Szerep hozzárendelések visszaállítása"
remove_role             = "Szerep eltávolítása"
reset_all_roles         = "Minden szerep visszaállítása"
label_ok_button         = "   OK   "
label_cancel_button     = " Mégse"
label_confirm_button    = " Megnézés "
known_addresses         = """<H3>Címjegyzékből</H3>
    Válassza ki a felhasználók közül a meghívandókat:<br>
    <SELECT NAME="%(name)s" MULTIPLE SIZE=6> %(known)s </SELECT><br>
    A (*) jelzésű felhasználók már tagjai a munkaterületnek.
    Amennyiben a felhasználónak csak email címe van, akkor még
    az adott felhasználó még nincs regisztrálva a szerveren.
"""
no_known_addresses      = """
A címjegyzéke jelenleg üres, vagy csak a munkaterület tagjait tartalmazza
"""
# Versioning strings
version_branches        = 'Kapcsolódó verzió-ágak'
version_history         = 'Verzió történet'
# License stuff
license                 = 'Licensz frissítése'
license_u_lim           = '<strong>%s</strong> számú felhaszálót engedélyez'
license_u_unlim         = '<strong>tetszőleges</strong> számú felhaszálót engedélyez'
license_u_reg           = ' (%s regisztrálva)'
license_e_lim           = 'lejár: <strong>%s</strong>'
license_e_unlim         = '<strong>nem</strong> jár le'
license_expired         = '<p><font color="red"><strong>A BSCW licensz érvénytelen:</strong></font> %s</p>'
license_expires         = '<p><font color="yellow">Megjegyzés: A BSCW licensz %s</font></p>'
license_new             = """<p><font color="red">
   <strong>Ön új BSCW licenszet kapott!</strong></font><br>
   Futtassa a hulldékgyűjtőt, mely telepíti az új licenszet.</p>
"""
admin_gc_running        = """<p><font color="green">
   <strong>A hulldékgyűjtő fut</strong></font>"""
# Error messages and responses
# Will probably be split off from lg_msgconfig to bs_respconfig in the future
# where HTTP status codes etc. will be handled too.
# message-type - cf. commonly used template short.html
error                   = 'Hiba:'
message                 = 'Üzenet:'
confirmation            = 'Megerősítés:'
restriction             = 'Korlátozás:'
# SYS_BUSY / SYS_MSG related:
systemmessage           = 'Rendszer-üzenet'
continueaccess          = 'Tovább'

notifyadmin             = 'Kérem értesítse a BSCW-adminisztrátort'

No_Permission           = ('error','Nem engedélyezett művelet',"""
    Ez a művelet nincs engedélyezve
""")
No_Access               = ('error','Nincs hozzáférés',"""
    Az Ön hozzáférési jogai nem elegendőek:<br>
    a(z) "<em>%(object)s</em>" objektum nem teszi lehetővé a
    "<em>%(op)s</em>" műveletet a(z) <em>%(name)s</em> felhasználó számára.
""")
No_UserAuth             = ('error','Bejelentkezés szükséges',"""
     A BSCW-szerver nem tudta eldönteni, hogy van-e
     hozzáférési joga a <em>%(user)s</em> felhasználó munkaterületéhez.
     Adja meg a <em>%(user)s</em> felhasználó helyes jelszavát.
""")
No_server               = ('error','Nincs szerver',"""
     <p>Ez a BSCW szerver pillanatnyilag nem elérhető.</p>
     %(_reason)s
""")
not_owner               = ('error','Nem tulajdonos',"""
     A műveletet csak a tulajdonos végezheti el.
""")
No_content_disposition  = ('error','Nem található','')
Bad_content_disposition = ('error','Tartalmi hiba','')
boundary_not_specified  = ('error','Határok meghatározása hiányzik','')
No_remote_addr          = ('error','Nincs távoli cím','')
Not_Found               = ('error','Nem található',"""
    Nem található: <strong>%(url)s</strong>
""")
Old_token               = ('error','Régi jogosultság',"""
    Az Ön jogosultsága lejárt.
""")
Bad_token               = ('error','Rossz jogosultság',"""
    A jogosultságot nem lehet újra felhaszbálni.
""")
Passwords_differ        = ('error','Különböző jelszó',"""
    A két jelszó eltér egymástól.
""")
No_Password             = ('error','Nincs jelszó',"""
    Az üres jelszó nem megengedett.
""")
quota_lock              = ('error','a tárolási kapacitás betelt',"""
    Ez a művelet nem lett végrehajtva, mert a %(quota_uname)s felhasználó
    rendelkezésére álló (%(quota_type)s quota) tárolási kapacitást túllépte volna.
    Törölje a nem használt dokumentumokat, majd ürítse ki a kukát is.
""")
quota_locked            = ('error','a tárolási kapacitás betelt',"""
    A tárolási kapacitás betelt (a %(quota_uname)s felhasználó
    %(quota_type)s kvótája ).
    Az előző művelet végrehajtásához %(quota_uname)s felhasználónak
    előbb <b>%(quota_exceed)s %(quota_unit)s-t törölnie kell</b>.
""")
bad_parameter           = ('error','Rossz paraméter',"""
    Rossz paraméter az URL-ben: <em>%(name)s</em>.
""")
missing_parameter       = ('error','Hiányzó paraméter',"""
    A hiányzó paraméter: "%(name)s".
""")
bad_pathinfo            = ('error','Érvénytelen útvonal',"""
    Érvénytelen útvonal az URL-ben.
""")
Already_registered      = ('error','Regisztrált cím',"""
    A <strong>%(address)s</strong> egy BSCW felhasználó email címe.
""")
no_mailaddr_selected    = ('error','Nincs kiválasztott email cím',"""
    Nincs kiválasztott email cím. Válassz ki annak az email címét, akit meg szeretne hívni.
""")
Bad_login_name          = ('error','Érvénytelen bejelentkezési név',"""
    Érvénytelen bejelentkezési név: <em>%(logname)s</em>.
    Maximum 16 karakter (alfa-numerikus vagy .-_ karakterek megengedettek) .
""")
Login_name_used         = ('error','Bejelentkezési név',"""
    A bejelentkezési név már használatban van.
    Próbáljon más nevet használni!
""")
Bad_object_selected     = ('error','Megengedhetetlen objektum lett kiválasztva',"""
    Igényelt objektumok: <strong>%(want)s</strong>,<br>
    kiválasztott objektumok: <strong>%(got)s</strong>.
""")
Cannot_commit           = ('error','A tárolás nem lehetséges',"""
    Módosításait a szerver nem tudta eltárolni.
    Kérem, kísérelje meg ismét.
""")
license_error           = ('error','Érvénytelen licensz',"""
    Módosításait a szerver nem tudta eltárolni, mert a BSCW-licensz érvénytelen.
    Hibakód: %(error)s
""")
content_unsupported     = ('error','Ismeretlen tartalom-típus (ContentType)',"""
    ContentType: %(contentType)s
""")
form_data_part_has_no_name = ('error','Hibás adatformátum',"""
    Űrlap-elem név nélkül. BSCW rendszer-hiba.
""")
multiple_values         = ('error','Multiple values',"""
    A <em>%(name)s</em> paraméter csak egy értéket vehet föl.<br>
    Leheséges érék: %(list)s
""")
object_wrong            = ('error','Nem dokumentum',"""
    Ez a művelet kizárólag dokumentumokkal végezhető.
""")
no_script_name          = ('error','Nincs művelet',"""
    Nincs érvényes művelet. BSCW rendszer-hiba.
""")
bad_script_name         = ('error','Bad script name',"""
    Bad script name: %(script_name)s<p>
    (BSCW configuration problem)</p>
""")
bad_smtphost            = ('error','Érvénytelen SMTP_HOST',"""
    Konfigurációs probléma: az SMTP_HOST nem elérhető
    (lásd: src/config.py).
""")
bad_serveradmin         = ('error','Érvénytelen SERVER_ADMIN',"""
    Konfigurációs probléma: érvénytelen SERVER_ADMIN email cím
    (lásd: src/config.py).
""")
bad_smtpsession         = ('error','SMTP hiba',"""
    SMTP átviteli hiba:<PRE>%(session)s</PRE>
""")
unsupported_method      = ('error','Nem-szupportált metódus',"""
    A BSCW nem szupportálja ezt a metódust.
""")
non_numeric_ids         = ('error','Nem-numerikus azonosító',"""
     Numerikus Objekt-azonosítót kell használni.
""")
no_operation            = ('error','Semmi sincs kiválasztva',"""
    Se Mime-típus (Mime-type), se Kódolási típus (Encoding-type) nem lett kiválasztva.
""")
engine_error            = ('error','%(engine_error)s',"""
    a kereső-motor hibaüzenete: <em>%(engine)s</em>.
""")
send_relocation         = ('error','Átirányítás',"""
    A dokumentum <A HREF="%(url)s">here</A> helyen található.
""")
no_archive              = ('error','Az archívum nem lett előállítva',"""
   A kijelölt objekumok közül egyik sem archíválható.
""")
archive_failed          = ('error','Az archívum nem lett előállítva',"""
Az Ön dokumentumai nem lettek archíválva - az archíváló program a következő
üzenettel állt le:<br />
<em>%(info)s</em>
""")
extract_failed          = ('error','Kicsomagolási hiba',"""
Az Ön dokumentumai nem lettek kicsomagolva - a kicsomagoló program a következő
üzenettel állt le:<br />
<em>%(info)s</em>
""")
conversion_failed       = ('error','Konvertálási hiba',"""
Az Ön dokumentumai nem lettek megkonvertálva - a konvertáló program a következő
üzenettel állt le:<br />
<em>%(info)s</em>
""")
transfer_failed         = ('error','Átviteli hiba',"""
   A dokumentumot nem lehetett letölteni, mert: <p> %(reason)s.</p>
""")
no_decoder              = ('error','Nincs dekóder',"""
  Nincs dekóder a %(encoding)s-hez telepítve.
""")
maddr_bad               = ('error','Érványtelen email cím',"""
   A <em>%(name)s</em>  BSCW email cím érvénytelen.
""")
maddr_exists            = ('error','Email cím létezik',"""
   A <em>%(name)s</em>  BSCW email cím már létezik.
""")
user_exists             = ('error','Felhasználó már létezik',"""
   A <em>%(name)s</em> BSCW felhasználó már létezik.
""")
user_not_exists         = ('error','Nemlétező felhasználó',"""
   A <em>%(name)s</em> BSCW felhasználó nem létezik.
""")
import_error            = ('error','Importálási hiba',"""
   A konfigurációs fájlban végrehajtott módosítások nem felelnek meg a Python
   szintaxisnak.
   <PRE>a %(lineno)s sorban:\n  %(line)s</PRE>
   %(type)s:&nbsp; %(value)s
""")
open_file               = ('error','Fájl-megnyitási hiba',"""
   A <i>%(name)s</i> fájlt %(mode)s-módban nem lehetett megnyitni.
""")
invalid_mime_type       = ('error','Érvénytelen MIME-Type',"""
   A MIME-type %(type)s nem típus/altípusból áll.
""")
empty_values            = ('error','Üres értékmegadás',"""
   A(z) %(values)s értékek üresek.
""")
user_search_limit_reached = ('korlátozás','Elérte a felhasználói keresési találat határát',"""
    Az Ön lekérdezése több találatot eredményezett, mint amennyi a felhasználóknak megengedett
    (%(limit)s találat).
    Kérem, finomítsa lekérdezését.
""")
no_vid                  = ('error','Érvénytelen verzió-szám',"""
    A verzió-szám "%(vid)s" érvénytelen.<p>
    Csak 0 és 32767 közé eső egész számokat lehet használni.</p>
""")
not_storeable           = ('error','Érvénytelen verzió-szám',"""
    A verzió-szám "%(vid)s" érvénytelen.<p>Egy új verzió-számnak,
    egy verzió-ágon belü nagyobbnak kell lennie a verzió-ágban eddig használt legnagyobb értéknél.</p>
""")
not_renameable          = ('error','Érvénytelen verzió-szám',"""
    A "%(vid)s".<p>  verzió-számot nem lehetett megváltoztatni.
    A verzió-számnak az előzőnél magasabbnak kell lennie.</p>
""")
to_field_empty          = ('error','A címzett-mező üres',"""
   A <b>Címzett</b> mező vagy üres, vagy a megadott email cím értékelhetetlen.
""")
message_to_large        = ('error','Az üzenet túl hosszú',"""
   Az Ön üzenete túl hosszú. Üzenetének becsült hossza
   ..., ám a mgengedett méret: %(limit)s.
""")
ext_already_use         = ('error','A kiterjesztés már használatban van.',"""
   A <b>%(ext)s</b> kiterjesztést már a <i>%(type)s</i> Mime-típus használja.
""")
ftp_error               = ('error','FTP hiba',"""
Az FTP átvitel a következő hibaüzenettel tért vissza:
<pre><b>
    %(ftp_error)s
</pre></b>
""")
export_reject_error     = ('error','Érvénytelen név',"""
A megadott név <i>%(name)s</i> használata a <i>%(site)s</i> célgép fájlrendszerében bonyodalmakhoz vezetne.
Kérem nevezze másként ezt a dokumentumot.
""")
admin_garbage_fail      = ('error','A huladékgyűjtő elindítása nem sikerült.',"""
A BSCW huladékgyűjtőt nem lehetett elindítani.""")
##############   end of language dependent part  ################
# Encodings (probably no translation)
compress                = 'Tömörítés'
gzip                    = 'Gzip'
uue                     = 'UUE'
# Main Types (probably no translation)
audio                   = 'Hang'
image                   = 'Kép'
model                   = 'Model'
text                    = 'Szöveg'
video                   = 'Hang'
menu_changedetails = changedetails_ChangeDetails = chpersdetails = changedetails

chprefs_Profile         = 'Felhasználói szint'

chprefs_KnownEditors    = 'Ismert szerkesztők'

btn_label_edit          = 'Szerkesztés'

btn_label_delete        = 'Törlés'

label_id                = 'ID'

label_name              = 'Név'

label_url               = 'URL'

label_icon              = 'Ikon'
#---------------------------------------------------------------------------
# language strings for operation 'show_totalreads'
#---------------------------------------------------------------------------
events_showtotal        = 'A &quot;%(name)s&quot;-t <b>%(read_count)s</b>-szor olvasták.'
#---------------------------------------------------------------------------
# language strings for operation 'show_readers'
#---------------------------------------------------------------------------
events_showreads        = 'Események megtekintése (<em>%(name)s</em>), %(since)s óta'
#---------------------------------------------------------------------------
# language strings for operation 'show_touches'
#---------------------------------------------------------------------------
events_showtouches      = 'Változások a <em>%(name)s</em>-ban %(since)s óta'
multi_drop              = drop
statusname              = 'Status'
typename                = 'Type'
undefined               = 'undefined'
participantstate        = 'Participance'
appointmentstate        = statusname
responsibility          = 'Responsibility'
isresponsible           = 'Responsible'
s_responsible           = label_responsible
Member_is_expired       = chpwd_3
Member_is_locked        = chpwd_1

help_translate          = """The Hungarian version may be incomplete. <a href="http://www.bscw.de/extensions.html">Help us translate BSCW to Hungarian!</a>"""
addfolder_Simple        = addfolder
addurl_Simple           = addurl
add2cal_Simple          = add2cal
partstat_state_1        = menu_partstat_state_1
partstat_state_2        = menu_partstat_state_2

editnote_ChNote         = editnote
editnote_EditNote       = editnote
addnote_AddNote         = addnote
# addnote_AttachNote      = attachnote
addnote_AddNotes        = addnotes
addctlist_Simple        = addctlist
menu_addfolder_Simple   = menu_addfolder
menu_adddocument_Simple = menu_adddocument
menu_adddocument_Basic  = menu_adddocument
menu_adddocument_Plain  = menu_adddocument
menu_addctlist_Simple   = menu_addctlist
menu_addurl_Simple      = menu_addurl
menu_addnote_AddNotes   = menu_addnotes
menu_addnote_AddNote    = menu_addnote
menu_add2cal_Simple     = menu_add2cal

changedetails_MessagingServices = 'Azonnali értesítés (Instant Messaging)'

link_getical            = 'Letöltés iCalendar formátumban'
#addworkspace_AddWorkspace = addworkspace
label_objects           = 'Objektumok száma'
